﻿/*
@author: jingleyang
@date: 2010-04-26
*/
$(function() {
	menu.init();
});

var menu = {};
var sidebarMenu={};
menu.getId = function() {
	var id = utils.parseUrl().id;
	return parseInt(id);
};

menu.init = function() {
	var id = menu.getId();
	browser.skin.menu.init(id);
};

menu.build = function(menuData) {
	try{
		//	menuData: [22,[],{"type":"main"}]
	    sidebarMenu.type = menuData[2].type; // 通过这个区分 是main , qzone 弹的框	
		sidebarMenu.init();			
	}catch(err){
		qqbrowser.log.info("init err "+err.message);
	}
};
menu.show = function(){
	var menuSize = view.getSize('menu');
	var menuId = menu.getId();
	try{
		qqbrowser.skin.menu.show(menuId, menuSize.width, menuSize.height);
	}catch(err){
	}	
};
sidebarMenu.hide=function(){
	try{
		qqbrowser.skin.menu.hideAll(menu.getId());
	}catch(err){
	}
};
sidebarMenu.regListener = function(){
	// 处理点击事件
	$("#sidebar-menu").click(function(){
		if ($(this).hasClass("selected")){
			// 去掉选中状态
			$(this).removeClass("selected");
			// set config 
			if(sidebarMenu.type == 'main') {
				var obj = {};
				obj['sidebarMainSwitch'] = 0;		
				configManager.setConfig(obj);
			}
			else if(sidebarMenu.type == 'qzone') {
				var obj = {};
				obj['sidebarQzoneSwitch'] = 0;		
				configManager.setConfig(obj);
			}
		}else{
			// 加上选中状态
			$(this).addClass("selected");
			// set config
			if(sidebarMenu.type == 'main') {
				var obj = {};
				obj['sidebarMainSwitch'] = 1;		
				configManager.setConfig(obj);
			}
			else if(sidebarMenu.type == 'qzone') {
				var obj = {};
				obj['sidebarQzoneSwitch'] = 1;		
				configManager.setConfig(obj);
			}
		}	
		var obj = {};
		var windowId = qqbrowser.window.currentId();
		qqbrowser.extension.event.broadcast('configChanged', obj, windowId);
		// 最后关闭菜单 ， 这里测试就没关闭
		//sidebarMenu.hide();	
	});	
};
// 初始化 sidebar menu
/*
   1 > config.get 选中状态
   2 > 注册点击事件 	
 */
sidebarMenu.init = function(){
	sidebarMenu.get_set_Stat();
	sidebarMenu.regListener();
	menu.show();
};

sidebarMenu.get_set_Stat = function(){
	// 设置选中状态，假设是 true
	if('main'==sidebarMenu.type) {
		configManager.getConfig(['sidebarMainSwitch'], sidebarMenu.getMainSwitchCallback);
	}
	else if('qzone'==sidebarMenu.type) {
		configManager.getConfig(['sidebarQzoneSwitch'], sidebarMenu.getQzoneSwitchCallback);
	}
}

sidebarMenu.getQzoneSwitchCallback = function(results) {
	var config = eval("(" + results + ")")[0];
	var configValue = config['sidebarQzoneSwitch'];	
	if(configValue) {		
		$("#sidebar-menu").addClass("selected");	
	} else {
		$("#sidebar-menu").removeClass("selected");	
	}
};

sidebarMenu.getMainSwitchCallback = function(results) {
	var config = eval("(" + results + ")")[0];
	var configValue = config['sidebarMainSwitch'];	
	if(configValue) {		
		$("#sidebar-menu").addClass("selected");	
	} else {
		$("#sidebar-menu").removeClass("selected");	
	}
};

